<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Logpost extends CheckAction {

    public function action_index()
    {
        if( Helper::checkActionInRole('Logpost without search') ){
            throw HTTP_Exception::factory(404, 'Not Found');
        }

        ini_set('memory_limit', '-1');
        $page = $this->request->param('page');

        /* RESET */
        if (null !== $this->request->post('reset')) {
            Session::instance()->delete('filter');
            HTTP::redirect('/');
        }

        /* Identity form */
        $this->request->post('_form', 'step1');
        
        /* Save query to My queries */
        if (null !== $this->request->post('save_to_my_queries')) {
            $post = $this->request->post();
            
            $post['name'] = $post['user_query_name'];
            unset($post['user_query_name']);
            
            $user_query = ORM::factory('User_Query');
            $user_query = $user_query->addOrUpdateQuery($post, Auth::instance()->get_user()->id);
            if ( $user_query ) {
                $messages['success'][] = 'Successfully saved query <a target="_blank" href="/myqueries/editor/' . $user_query->id . '">' . $user_query->name . '</a> to My queries';
                Session::instance()->set('messages', $messages);
                $this->request->post('user_query', $user_query->id);
                $this->request->post('filter', 'Apply');
            } else {
                $messages['errors'] = $user_query->getErrors();
            }
        }
        
        /* Save filter and redirect */
        if (Request::POST == $this->request->method() && null !== $this->request->post('filter')) {
            $session = Session::instance();
            $session->set('filter', $this->request->post());
            HTTP::redirect('/page/1');
        }
        
        /* If isset session set post data */
        if (Session::instance()->get('filter')) {
            $post = Session::instance()->get('filter');
            $this->request->post($post);
            $messages = Session::instance()->get_once('messages');
        }

        /****************************************
         * FILTER
         ****************************************/
        if (null !== $this->request->post('filter')) {
            $model = Model::factory('Logpost');
            
            // Load user query
            if ($this->request->post('user_query')) {
                $currentUser = Auth::instance()->get_user();
                $userQuery = $currentUser->queries->where('id', '=', (int)$this->request->post('user_query'))->find();
                if ( ! $userQuery->loaded())
                {
                    throw HTTP_Exception::factory(400);
                }
                $post = array_filter($this->request->post()) + $userQuery->getAsPost();
                $this->request->post($post);
            }
            
            // Process query
            try {
                $output = $model->processQuery($this->request->post(), $page);

                if (isset($output['array']) && $output['array'] != null) {
                    $array = $output['array'];
                    $pagination = $output['pagination'];
                    if (isset($output['messages'])) {
                        $messages = array_merge(isset($messages) ? $messages : [], $output['messages']);
                    }
                }
            } catch(Exception_FilterLogpostProcessing $e) {
                $messages = array_merge(isset($messages) ? $messages : [], (array)$e->getMessages());
            }
        }
        
        $locations = array_values(Kohana::$config->load('locations')->as_array());
        $locations = array_combine($locations, $locations);
        $cpp = Kohana::$config->load('cbp')->as_array();
        $user_queries = Auth::instance()->get_user()->getUserQueries();
        
        $this->template->content = View::factory('welcome/v_index_filter_sphinx')
            ->bind('array', $array)
            ->bind('pagination', $pagination)
            ->bind('locations', $locations)
            ->bind('cpp', $cpp)
            ->bind('user_queries', $user_queries)
            ->set('post', $this->request->post())
            ->bind('messages', $messages);
    }

    public function action_more(){
	    $id = $this->request->param('id');
	    $client_name = $this->request->param('name');

	    $logpost = DB::select()
		    ->from('logpost')
		    ->where('id', '=', $id)
		    ->limit(1)
		    ->execute();
	    $logpost = $logpost[0];

	    if($client_name == ''){
		    $client = Model::factory('Client')->getClientInfo($logpost['client_id']);
		    HTTP::redirect('/logpost/more/'.$client['client'].'/'.$id, 301);
	    }

	    $client = Model::factory('Client')->getClientInfo($client_name);
        if (false === $client || $logpost['client_id'] != $client['id']) {
            throw HTTP_Exception::factory(404);
        }
        
	    $net_access = Auth::instance()->get_user()->getNetAccess();
        if ( ! empty($net_access) && ! in_array(trim($logpost['group']), $net_access) ) {
		    throw HTTP_Exception::factory(403);
	    }

        $data = json_decode($logpost['data'], true);

        $client['geo'] = geoip_record_by_name($client['ip']);
        if($client['geo']['region']){
            $client['geo']['region_name'] = geoip_region_name_by_code($client['geo']['country_code'], $client['geo']['region']);
        }
        $client['geo']['org'] = geoip_asnum_by_name($client['ip']);
        $client['geo']['resolve'] = gethostbyaddr($client['ip']);

	    $this->template->content = View::factory('welcome/v_more')
		    ->bind('client', $client)
		    ->bind('data', $data)
		    ->bind('logpost', $logpost);
    }

    public function action_more_ex(){
        ini_set('memory_limit', '-1');
	    $time_start = date('Y-m-d H:i:s');
	    $time_start_ms = microtime(true);
        $limit = 1000;
        $client = $this->request->param('id');
        if(($page = $this->request->param('page')) == null){
            $page = 1;
        }

	    /* RESET */
	    if (null !== $this->request->post('reset')) {
		    Session::instance()->delete('more_ex');
		    HTTP::redirect('/logpost/more_ex/'.$client);
	    }

	    /* Identity form */
	    $this->request->post('_form', 'step2');

	    /* Save filter and redirect */
	    if (Request::POST == $this->request->method() && null !== $this->request->post('filter') ) {
		    $session = Session::instance();
		    $session->set('more_ex', $this->request->post());
		    HTTP::redirect('/logpost/more_ex/'.$client.'/1');
	    }

	    /* If isset session set post data */
	    if (Session::instance()->get('more_ex')) {
		    $post = Session::instance()->get('more_ex');
		    $this->request->post($post);
	    } else {
		    $post = $this->request->post();
	    }

        $model = Model::factory('Client');
        $client = $model->getClientInfo(
            $model->getCid($client)
        );

        /* if client not exists */
        if(empty($client)){
            throw HTTP_Exception::factory(404, 'Not Found');
        }

        $net_access = Auth::instance()->get_user()->getNetAccess();
        if ( ! empty($net_access) && ! in_array($client['net'], $net_access)) {
            throw HTTP_Exception::factory(403);
        }
        
        $post['client'] = "<a href='/logpost/more_ex/" . $client['client'] . "'>" . $client['client'] . "</a>";
        $performanceLog = Model_Log::createLog($post, $time_start);
        $performanceLog->count_client_filter = 0;
        $performanceLog->time_client_filter = 0;
        $performanceLog->time_find_clients = microtime(true) - $time_start_ms;
        $performanceLog->count_find_clients = 1;

        $sphinxql = new SphinxQL();
	    $queryLogpost = $sphinxql->new_query()
            ->add_index('logpost')
            ->add_field('id')
            ->where('client_id', $client['id'], '=');

        Model::factory('Logpost')->offsetSphinxQL($page, $limit, $queryLogpost);

	    /* TODO: add logkeys as bool in sphinx index */
//	    if(Arr::get($post, 'logkeys')){
//		    $queryLogpost->where('logkeys', 1, '=');
//	    }

        /* LINK */
        if (Arr::get($post, 'link')) {
            $link = explode('|', Arr::get($post, 'link'));
            $link = array_map(['Helper', 'EscapeSphinxQL'], $link);
            $link = array_map(['Helper', 'MultiSphinxQL'], $link);
            $queryLogpost->search("@link (*" . implode('*)|(*', $link) . "*)");
        }

        /* START - END */
        if (Arr::get($post, 'date_start') && Arr::get($post, 'date_end')) {
            $start = strtotime($post['date_start']);
            $end = strtotime($post['date_end']);
            $end = strtotime("+1 day", $end);
            $queryLogpost->where('datetime', $start.' AND '.$end, 'BETWEEN');
        }

        $indexLogposts = $queryLogpost->execute(Helper::getCurrentSphinx());
        $performanceLog->time_find_logposts = $indexLogposts['total_info']['time'];
        $performanceLog->count_find_logposts = count($indexLogposts['data']);

        $pagination = Pagination::factory([
            'total_items' => $indexLogposts['total_info']['total_found'],
            'items_per_page' => $limit
        ]);

        $ids = array();
        foreach($indexLogposts['data'] as $l){
            $ids[] = $l['id'];
        } unset($l);
        unset($indexLogposts);

        if(!empty($ids)){
	        $time_find_logposts_db_start = microtime(true);
            $dbLogposts = DB::select('id', 'link', 'datetime','logkeys')
                ->from('logpost')
                ->where('id', 'IN', $ids)
                ->order_by('datetime', 'DESC')
//              ->limit(count($ids)) // TODO check in big data
                ->execute()
                ->as_array();
            $time_find_logposts_db = microtime(true) - $time_find_logposts_db_start;
        } else {
            $time_find_logposts_db = 0;
        }
        
        $performanceLog->time_find_logposts_db = $time_find_logposts_db;
        $performanceLog->time_total = microtime(true) - $time_start_ms;
        $performanceLog->save();

        $this->template->content = View::factory('welcome/more_ex/v_index')
            ->bind('client', $client)
            ->bind('logpost', $dbLogposts)
            ->bind('pagination', $pagination)
            ->set('post', $this->request->post());
    }
    
    public function action_user_query()
    {
        if ( ! $this->request->is_ajax() || Request::GET != $this->request->method())
        {
            throw HTTP_Exception::factory(405)->allowed([Request::GET]);
        }

        $user_query_id = $this->request->query('user_query');
        
        $filter = Auth::instance()->get_user()
            ->queries
            ->where('id', '=', $user_query_id)
            ->find();
        if ( ! $filter->loaded() )
        {
            throw HTTP_Exception::factory(404);
        }
        
        $result = [];
        $result['host'] = $filter->host;
        $result['host_strong'] = $filter->host_strong;
        $result['net'] = $filter->net;
        $result['length'] = $filter->length;
        $result['referrer'] = $filter->referrer;
        $result['link'] = $filter->link;
        $result['link_strong'] = $filter->link_strong;
        $result['ip'] = $filter->ip;
        if ( $filter->date_start )
        {
            $result['date_start'] = date('Y/m/d', strtotime($filter->date_start));
        }
        if ( $filter->date_end )
        {
            $result['date_end'] = date('Y/m/d', strtotime($filter->date_end));
        }
        $result['version'] = $filter->version;
        
        $this->auto_render = false;
        $this->response->headers('Content-Type', 'application/json; charset=' . Kohana::$charset);
        $this->response->body(json_encode($result));
    }

    public function action_mini(){
        ini_set('memory_limit', '-1');
        $page = $this->request->param('page');

        /* RESET */
        if (null !== $this->request->post('reset')) {
            Session::instance()->delete('filter');
            HTTP::redirect('/logpost/mini');
        }

        /* Identity form */
        $this->request->post('_form', 'mini');

        /* Save filter and redirect */
        if (Request::POST == $this->request->method() && null !== $this->request->post('filter')) {
            $session = Session::instance();
            $session->set('filter', $this->request->post());
            HTTP::redirect('/logpost/mini/page/1');
        }

        /* If isset session set post data */
        if (Session::instance()->get('filter')) {
            $post = Session::instance()->get('filter');
            $this->request->post($post);
            $messages = Session::instance()->get_once('messages');
        }

        $listFilter = Model_Logpost::getFilter(['link', 'referrer']);
        if(!$listFilter) {
            $this->request->post('mini', true);
        }else{
            foreach ($listFilter as $k => $l){
                $listFilter[$k] = explode('|', $l);
                $listFilter[$k] = array_filter($listFilter[$k]);
                $listFilter[$k] = array_map('trim', $listFilter[$k]);
                array_unshift($listFilter[$k], '-');
                $listFilter[$k] = array_combine($listFilter[$k], $listFilter[$k]);
                $listFilter[$k]['-'] = ucfirst($k);
            }
        }

        $this->request->post('cpp', 20);

        /****************************************
         * FILTER
         ****************************************/
        if (null !== $this->request->post('filter')) {
            $model = Model::factory('Logpost');

            // Load user query
            if ($this->request->post('user_query')) {
                $currentUser = Auth::instance()->get_user();
                $userQuery = $currentUser->queries->where('id', '=', (int)$this->request->post('user_query'))->find();
                if ( ! $userQuery->loaded())
                {
                    throw HTTP_Exception::factory(400);
                }
                $post = array_filter($this->request->post()) + $userQuery->getAsPost();
                $this->request->post($post);
            }

            // Process query
            try {
                $output = $model->processQuery($this->request->post(), $page);

                if (isset($output['array']) && $output['array'] != null) {
                    $array = $output['array'];
                    $pagination = $output['pagination'];
                    if (isset($output['messages'])) {
                        $messages = array_merge(isset($messages) ? $messages : [], $output['messages']);
                    }
                }
            } catch(Exception_FilterLogpostProcessing $e) {
                $messages = array_merge(isset($messages) ? $messages : [], (array)$e->getMessages());
            }
        }

        $locations = array_values(Kohana::$config->load('locations')->as_array());
        $locations = array_combine($locations, $locations);
        $user_queries = Auth::instance()->get_user()->getUserQueries();

        $this->template->content = BladeView::factory('logpost/mini/index')
            ->bind('array', $array)
            ->bind('pagination', $pagination)
            ->bind('locations', $locations)
            ->bind('user_queries', $user_queries)
            ->bind('listFilter', $listFilter)
            ->set('post', $this->request->post())
            ->bind('messages', $messages);
    }
    
}